IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[Respondent]') and OBJECTPROPERTY(id, N'IsView') = 1)
  DROP VIEW [dbo].[Respondent]
GO

CREATE VIEW [dbo].[Respondent] AS
	SELECT
		respondentCATI.CommandCenterPrimaryKeyCopy AS ResRespondent,
		(select qc.position from QuestionCode qc
			INNER JOIN LabelContent lc on lc.Id=qc.Label and lc.Language=qc.Code
			WHERE qc.Questionnaire=projPageQuestId.StaticValue and qc.alias='LANG' and qc.Code=res.ResLanguageCode)
		AS ResLanguage,
		timezones.Id AS ResTimeZone,
		respondentCATI.CallBackDate AS ResCallbackDate,
		respondentCATI.InterviewerId AS ResIntervCall,
		ISNULL(respondentCATI.TimeSlot, 0) AS ResTimeSlot,
		ResCallCount AS ResCallCount,
		ResLastCallDate AS ResLastCallDate,
		CONVERT(varchar,NULL) AS ResVersion,
		respondentCATI.Priority AS ResPriority,
		CONVERT(bit, CASE ResDisposition WHEN 1 THEN 1 ELSE 0 END) AS ResCompleted,
		CONVERT(bit, 0) AS ResConfidPhone,
		CONVERT(float, ResRespondent) AS ResSeed,
		LEFT(ResPhone, 20) AS ResPhone,
		LEFT(res.ResCodeResult, 2) AS ResCodeResult,
		res.ResWaveNo AS ResWaveNo,
		ResBlocked AS ResBlocked,
		respondentCATI.PredictiveDialing AS ResCompPredictive,
		ResCall AS ResCall,
		CONVERT(bit, 0) AS ResMonitored,
		res.ResLastCompQuest AS ResLastCompQuest,
		ResPreviousCallDate AS ResPreviousCallDate,
		ResWaveImportNo AS ResWaveImportNo,
		944 AS projectId,
		CASE ResCallCount
			WHEN 0 THEN 0
			ELSE 1 -- 1 s for CATI. To be confirmed
		END
		AS collectMode,
		res.modifiedBy AS modifiedBy,
		res.Modified AS modified,
		panelistId AS PanelistId,
		CASE Location
			WHEN 0 THEN N'Server'
			WHEN 1 THEN N'Device'
			ELSE 'Server'
		END
		AS [Location],
		ResActive AS ResActive,
		respondentCATI.DialingMode AS DialingMode,
		CONVERT(bit, 0) AS RestrictionOverride,
		0 AS IntLevel,
		CONVERT(NVARCHAR, NULL) AS ResNextIntervCall,
		CONVERT(BIT,
			CASE CyclePhoneNumber
			WHEN NULL THEN 0
			WHEN 0 THEN 0
			ELSE 1 END
		)
		AS CyclePhoneNumber,
		CAST(ManualDialing AS INT) AS ManualDialing,
		IsAnonymized AS IsAnonymized,
		CONVERT(DATETIME, NULL) AS ResCompletedDate
	FROM [A4Survey_Client_1].[Survey_1_4198].[Respondent] res
	-- Add RespondentCATI information. Each respondent should have exactly one RespondentCATI entry
	INNER JOIN [A4Survey_Client_1].[Survey_1_4198].[RespondentCATI] respondentCATI ON respondentCATI.Id=ResRespondent
	LEFT JOIN [VoxcoSystem].[dbo].[Timezones] timezones ON timezones.MSTimeZoneID=ResTimeZone
	-- Get the questionnaire id using the hardcoded database id of the project and the "QuestionnaireId" key
	INNER JOIN [VoxcoSystem].[dbo].[tblPages] projPageQuestId ON k_Id=944 AND Name='QuestionnaireId'
GO

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[Response]') and OBJECTPROPERTY(id, N'IsView') = 1)
  DROP VIEW [dbo].[Response]
GO

CREATE VIEW [dbo].[Response] AS
	SELECT
		respondentCATI.CommandCenterPrimaryKeyCopy AS RpsRespondent,
		CONVERT(nvarchar(32), res.RpsQuestion) AS RpsQuestion,
		CONVERT(bigint, res.RpsMatrix) AS RpsMatrix,
		res.RpsMention AS RpsMention,
		CONVERT(nvarchar(100), res.RpsContent) AS RpsContent,
		res.RpsOpened AS RpsOpened,
		0 AS RpsType,
		944 as projectId,
		0 AS collectMode,
		res.modifiedBy AS modifiedBy,
		res.modified AS modified,
		CONVERT(nvarchar(max), '') AS Source,
		0 AS CallId,
		0 AS QuestionOrder,
		0 AS ChoiceOrder
	FROM [A4Survey_Client_1].[Survey_1_4198].[Response] res
	-- Add RespondentCATI information. Each respondent should have exactly one RespondentCATI entry
	INNER JOIN [A4Survey_Client_1].[Survey_1_4198].[RespondentCATI] respondentCATI ON respondentCATI.Id=RpsRespondent

GO

